<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hamdala Sub</title>

    <!-- Bootstrap 5 CDN-Import: -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-1BmE4kWBq78iYhFldvKuhfTAU6auU8tT94WrHftjDbrCEXSU1oBoqyl2QvZ6jIW3" crossorigin="anonymous">
    
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta2/css/all.min.css" integrity="sha512-YWzhKL2whUzgiheMoBFwW8CKV4qpHQAEuvilg9FAn5VJUDwKZZxkJNuGM4XkWuk94WCrrwslk8yWNGmY1EduTA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    
    <!-- Light-Theming: -->
    <link id="mainStyle" rel="stylesheet" href="assets/css/style.css">

    <!-- Dark-Theming: -->
    <!-- Uncomment the line below to use dark theming. Don't forget to comment the line above.-->
    <!-- <link rel="stylesheet" href="assets/css/style_dark.css"> -->
    <!-- this also works automatically by clicking the theme_button. -->
</head>
<body>

    <div class="page-content d-flex align-items-center">

        <div class="container d-flex justify-content-center">

            <div class="col-12 col-sm-10 col-md-8 col-lg-7 col-xl-6 col-xxl-5">

                <div class="auth-card">

                    <div class="logo-area">

                        <!-- Light-Theming Logo: -->
                        <!--img id="header_logo" class="logo" src="assets/img/logo.png" />

                        <!-- Dark-Theming: -->
                        <!-- <img class="logo" src="assets/img/logo_dark.png" /> -->

                    </div>

                    <!--h5 class="auth-title"><?php echo $sitename; ?></h5-->

                    <div class="user-top text-center mt-n5">
                    <img src="../../assets/images/icons/Black and White Minimalist Professional Initial Logo_20250915_214201_0000-modified.png
                    " style="border-radius:5rem; width:100px; height:100px; margin-right:10px;">
                    <div class="text-center mt-3">
                        <h1 class="font-25 mb-3 color-highlight">REGISTER</h1>
                        <h6 class="mb-3 text-dark">
                            Enter your details below to create a free account
                        </h6>
                    </div>
                </div>
                
                    <!-- Signup-Form -->
                    <form id="reg-form" method="post">
                        <div id="regDiv">

                        <div class="mb-2 mt-5">
                            <input type="text" class="form-control auth-input" id="fname" name="fname" placeholder="First Name" required />
                            <label for="name" class="color-highlight">First Name</label>
                                        <em>(required)</em>
                        </div>

                        <div class="mb-2">
                            <input type="text" class="form-control auth-input" id="lname" name="lname" placeholder="Last Name" required />
                            <label for="name" class="color-highlight">Last Name</label>
                                        <em>(required)</em>
                        </div>

                        <div class="mb-3">
                            <input type="number" class="form-control auth-input" id="phone" name="phone" placeholder="Phone" required readonly />
                            <label for="phone" class="color-highlight">Phone Number</label>
                                        <em>(required)</em>
                        </div>
                        
                        <div class="mb-3">
                            <input type="email" class="form-control auth-input" id="email" name="email" placeholder="Email" readonly />
                            <label for="email" class="color-highlight">Email</label>
                                        <em>(required)</em>
                        </div>
                        <input id="account" name="account" type="hidden" value="1" />

                                    <a id="next-btn" class="btn auth-btn mt-2 mb-4">
                                        Continue
                                    </a>
                                
                            
                        </div>
                        <div id="nextregDiv" style="display:none;">
                        <div class="mb-2 mt-5">
                            <select class="form-control" id="state" name="state" required>
                                            <option value="" selected disabled>State</option>
                                            <option value="Abuja FCT" style="color:#000000 !important;">Abuja FCT</option>
                                            <option value="Abia" style="color:#000000 !important;">Abia</option>
                                            <option value="Adamawa" style="color:#000000 !important;">Adamawa</option>
                                            <option value="Akwa Ibom" style="color:#000000 !important;">Akwa Ibom</option>
                                            <option value="Anambra" style="color:#000000 !important;">Anambra</option>
                                            <option value="Bauchi" style="color:#000000 !important;">Bauchi</option>
                                            <option value="Bayelsa" style="color:#000000 !important;">Bayelsa</option>
                                            <option value="Benue" style="color:#000000 !important;">Benue</option>
                                            <option value="Borno" style="color:#000000 !important;">Borno</option>
                                            <option value="Cross River" style="color:#000000 !important;">Cross River</option>
                                            <option value="Delta" style="color:#000000 !important;">Delta</option>
                                            <option value="Ebonyi" style="color:#000000 !important;">Ebonyi</option>
                                            <option value="Edo" style="color:#000000 !important;">Edo</option>
                                            <option value="Ekiti" style="color:#000000 !important;">Ekiti</option>
                                            <option value="Enugu" style="color:#000000 !important;">Enugu</option>
                                            <option value="Gombe" style="color:#000000 !important;">Gombe</option>
                                            <option value="Imo" style="color:#000000 !important;">Imo</option>
                                            <option value="Jigawa" style="color:#000000 !important;">Jigawa</option>
                                            <option value="Kaduna" style="color:#000000 !important;">Kaduna</option>
                                            <option value="Kano" style="color:#000000 !important;">Kano</option>
                                            <option value="Katsina" style="color:#000000 !important;">Katsina</option>
                                            <option value="Kebbi" style="color:#000000 !important;">Kebbi</option>
                                            <option value="Kogi" style="color:#000000 !important;">Kogi</option>
                                            <option value="Kwara" style="color:#000000 !important;">Kwara</option>
                                            <option value="Lagos" style="color:#000000 !important;">Lagos</option>
                                            <option value="Nassarawa" style="color:#000000 !important;">Nassarawa</option>
                                            <option value="Niger" style="color:#000000 !important;">Niger</option>
                                            <option value="Ogun" style="color:#000000 !important;">Ogun</option>
                                            <option value="Ondo" style="color:#000000 !important;">Ondo</option>
                                            <option value="Osun" style="color:#000000 !important;">Osun</option>
                                            <option value="Oyo" style="color:#000000 !important;">Oyo</option>
                                            <option value="Plateau" style="color:#000000 !important;">Plateau</option>
                                            <option value="Rivers" style="color:#000000 !important;">Rivers</option>
                                            <option value="Sokoto" style="color:#000000 !important;">Sokoto</option>
                                            <option value="Taraba" style="color:#000000 !important;">Taraba</option>
                                            <option value="Yobe" style="color:#000000 !important;">Yobe</option>
                                            <option value="Zamfara" style="color:#000000 !important;">Zamfara</option>
                                        </select>
                            <label for="state" class="color-highlight">State</label>
                                        <em>(required)</em>
                        </div>

                        <div class="mb-2">
                            <input type="password" class="form-control auth-input" id="password" name="password" placeholder="Password" required readonly />
                            <label for="name" class="color-highlight">Password</label>
                                        <em>(required)</em>
                        </div>

                        
                        
                        <div class="mb-3">
                            <input type="password" class="form-control auth-input" id="cpassword" name="cpassword" placeholder="Confirm Password" required readonly />
                            <label for="cpassword" class="color-highlight">Confirm Password</label>
                                        <em>(required)</em>
                        </div>
                    
                        <div class="mb-3">
                            <input type="number" class="form-control auth-input" id="transpin" name="transpin" placeholder="4 Digit Pin" required />
                            <label for="transpin" class="color-highlight">Transaction Pin</label>
                                        <em>(required)</em>
                        </div>
                    
                        <input type="hidden" value="" id="referal" name="referal" />

                        <button type="submit" id="submit-btn" class="btn auth-btn mt-2 mb-4">Registration</button>
                        </div>

                    </form>

                    <p class="text mb-4">Already have an account? <a href="../login/" class="text-link">Login</a></p>
                    

                </div>
            </div>
        </div>
    </div>


    <button id="theme_button" class="btn btn-theme" onclick="onThemeChange()">
        <i id="theme_icon" class="fas fa-moon"></i>
    </button>


    <script type="text/javascript">
        function onThemeChange() {
            let cssStyleSheet = document.getElementById("mainStyle");
            let path = (cssStyleSheet.href).substring((cssStyleSheet.href).length-9, (cssStyleSheet.href).length);
            if(path === "style.css") {
                cssStyleSheet.href = "assets/css/style_dark.css";
                document.getElementById("header_logo").src = "assets/img/logo_dark.png";
                document.getElementById("theme_icon").className = "fas fa-sun";
            } else {
                cssStyleSheet.href = "assets/css/style.css";
                document.getElementById("header_logo").src = "assets/img/logo.png";
                document.getElementById("theme_icon").className = "fas fa-moon";
            }
        }
    </script>


    <!-- Bootstrap 5 JS-Bundle CDN import: -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js" integrity="sha256-/xUj+3OJU5yExlq6GSYGSHk7tPXikynS7ogEvDej/m4=" crossorigin="anonymous"></script>
<script type="text/javascript" src="../assets/scripts/bootstrap.min.js"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script type="text/javascript" src="../assets/scripts/custom.js"></script>

<script type="text/javascript">
$("document").ready(function(){

    //Enable Form Input
    $("#email").click(function(){$(this).removeAttr("readonly"); });
    $("#phone").click(function(){$(this).removeAttr("readonly"); });
    $("#password").click(function(){$(this).removeAttr("readonly"); });
    $("#cpassword").click(function(){$(this).removeAttr("readonly"); });

    //Next Btn
    $("#next-btn").click(function(){
        
        $msg="";
        
        $('#next-btn').removeClass("gradient-highlight");
        $('#next-btn').addClass("btn-secondary");
        $('#next-btn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');
            
        
        if($("#account").val() == "" || $("#account").val() == " "){$msg="Please Select Account Type.";}
        if($("#email").val() == "" || $("#email").val() == " "){$msg="Please Enter Email.";}
        if($("#phone").val() == "" || $("#phone").val() == " "){$msg="Please Enter Phone Number.";}
        if($("#lname").val() == "" || $("#lname").val() == " "){$msg="Please Enter Last Name.";}
        if($("#fname").val() == "" || $("#fname").val() == " "){$msg="Please Enter First Name.";}
        
        

        if($msg != ""){
            
            swal("Alert!!",$msg,"info");

            $('#next-btn').removeClass("btn-secondary");
            $('#next-btn').addClass("gradient-highlight");
            $('#next-btn').html("Continue");
            
            return;
        }

        $("#regDiv").hide();
        $("#nextregDiv").show();

    });


    //Registration Form
    $('#reg-form').submit(function(e){
            e.preventDefault();
            $msg=""; 
            if($("#password").val().length > 15){$msg="Password should not be more than 15 character.";}
            if($("#password").val().length < 8){$msg="Password should be at least 8 character.";}
           
            if($("#password").val() == $("#phone").val()){$msg="You can't use your phone number as password.";}
            if($("#password").val() == "" || $("#password").val() == " "){$msg="Please Enter Password.";}
            if($("#state").val() == "" || $("#state").val() == " "){$msg="Please Select State.";}
            if(($("#password").val()) != ($("#cpassword").val())){$msg="Password Is Different From Confirm Password.";}
            if($("#transpin").val().length != 4){$msg="Please enter a 4 digit pin";}

            if($msg != ""){swal("Alert!!",$msg,"info");  $msg=""; return; }
            
            $('#submit-btn').removeClass("gradient-highlight");
            $('#submit-btn').addClass("btn-secondary");
            $('#submit-btn').html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> Processing ...');
            
            $.ajax({
                url:'../home/includes/route.php?register',
                data: new FormData($(this)[0]),
                cache: false,
                contentType: false,
                processData: false,
                method: 'POST',
                type: 'POST',
                success:function(resp){
                    
                    resp = JSON.parse(resp);

                    if(resp.status == "success"){
                        swal('Alert!!',"Registration Succesfull","success");
                        setTimeout(function(){
                            location.replace('../home/')
                        },1000);
                    }
                    else{
                        swal('Alert!!',resp.msg,"error");
                        $("#nextregDiv").hide(); $("#regDiv").show();
                   }

                   $('#submit-btn').removeClass("btn-secondary");
                   $('#submit-btn').addClass("gradient-highlight");
                   $('#submit-btn').html("Register");

                   $('#next-btn').removeClass("btn-secondary");
                   $('#next-btn').addClass("gradient-highlight");
                   $('#next-btn').html("Register");

                }
            })
        });
});
</script>

</body>
</html>
